implementation module
	SparkleEnv

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 2.0
//	Copyright 1995 University of Nijmegen
//
// This is a modified version of the Standard Environment for Clean 2.0.
// The modifications were made to make it easier to prove properties of programs
// using Sparkle.
//
// The modifications do not change the semantics of the Standard Environment
// (except for drop and take on negative arguments and all functions that
//  depend on them), but do effect the efficiency of programs. It is therefore
// safe to use this standard environment, but programs may run slower.
//
// Additionally, several functions have been added to the Standard Environment.
// These functions are all defined in this module.
//
// All modifications to the standard environment are marked with the comment
// tags 'Sparkle'.
//
// Maarten de Mol.
// 21 December 2001
// ****************************************************************************************

import
	StdEnv

// ========================================================================================
// Returns True if the argument contains no '_|_' (and is finite) and _|_ otherwise.
// Defined by means of overloading. Use is made of strictness annotations to enforce
// evaluation of basic values.
// ----------------------------------------------------------------------------------------
class eval a :: !a -> Bool
// ----------------------------------------------------------------------------------------

// ----------------------------------------------------------------------------------------
instance eval Bool
// ----------------------------------------------------------------------------------------
where
	eval :: !Bool -> Bool
	eval x
		= True

// ----------------------------------------------------------------------------------------
instance eval Char
// ----------------------------------------------------------------------------------------
where
	eval :: !Char -> Bool
	eval x
		= True

// ----------------------------------------------------------------------------------------
instance eval Int
// ----------------------------------------------------------------------------------------
where
	eval :: !Int -> Bool
	eval x
		= True

// ----------------------------------------------------------------------------------------
instance eval Real
// ----------------------------------------------------------------------------------------
where
	eval :: !Real -> Bool
	eval x
		= True

// ----------------------------------------------------------------------------------------
instance eval [a] | eval a
// ----------------------------------------------------------------------------------------
where
	eval :: ![a] -> Bool | eval a
	eval [x:xs]
		= eval x && eval xs
	eval []
		= True

// ========================================================================================
// Returns True if the function can be applied to all elements of the list without
// ever producing _|_.
// PS: Can only be fulfilled if the argument list is spine evaluated.
// ----------------------------------------------------------------------------------------
evalFilter :: !(a -> Bool) ![a] -> Bool
// ----------------------------------------------------------------------------------------
evalFilter p [x:xs]
	= case p x of
		True	-> evalFilter p xs
		False	-> evalFilter p xs
evalFilter p []
	= True

// ========================================================================================
// Returns True for all finite (= spine evaluated) lists.
// Returns bottom (undefined) for all other lists.
// ----------------------------------------------------------------------------------------
finite :: ![a] -> Bool
// ----------------------------------------------------------------------------------------
finite [x:xs]
	= finite xs
finite []
	= True